<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Mobileuser_modal
 *
 * @author mahed
 */
class Mobileuser_modal extends CI_Model {

    public function __construct() {
        $this->load->database();
    }

    public function exit_user($username) {
        $this->db->select();
        $this->db->from('z_mobile_user');
        $this->db->where('username', $username);
        $query = $this->db->get();
        $farmer = $query->first_row('array');
        return $farmer;
    }

    public function add_user($data) {
        $this->db->insert('z_mobile_user', $data);
    }

    public function edit_user($username, $data) {
        $this->db->where('username', $username);
        $this->db->update('z_mobile_user', $data);
    }

    public function delete_user($data) {
        $this->db->delete('z_mobile_user', $data);
    }

    public function exit_current_password($current_password, $username) {
        $this->db->select();
        $this->db->from('z_mobile_user');
        $this->db->where('username', $username);
        $this->db->where('password', $current_password);
        $query = $this->db->get();
        $farmer = $query->first_row('array');
        return $farmer;
    }

    public function edit_password($password, $username) {
        $data = array('password' => md5($password));
        $this->db->where('username', $username);
        $this->db->update('z_mobile_user', $data);
    }

    public function get_area() {
        $this->db->select('name');
        $this->db->from('area');
        $query = $this->db->get();
        return $query->result();
    }

    public function insert_executive($data_executive, $data_area, $data_range) {
        $this->db->trans_begin();
        $this->db->insert('z_mobile_user', $data_executive);
        if ($data_area != null) {
            foreach ($data_area as $value) {
                $data = array('area' => $value, 'executive' => $data_executive['username']);
                $this->db->insert('z_area_executive', $data);
            }
        }
        if ($data_range != null) {
            foreach ($data_range as $value) {
                $this->db->insert('z_executive_range', $value);
            }
        }
        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
        } else {
            $this->db->trans_commit();
        }
    }

    public function get_user() {
        $this->db->select('username,firstname,lastname,mobile,type');
        $this->db->from('z_mobile_user');
        $this->db->where('type', 'Executive');
        $query = $this->db->get();
        return $query->result();
    }

    public function get_user_one($username) {
        $this->db->select('username,firstname,lastname,mobile');
        $this->db->from('z_mobile_user');
        $this->db->where('username', $username);
        $query = $this->db->get();
        $user = $query->first_row('array');
        return $user;
    }

    public function get_area_select($username) {
        $this->db->select('area');
        $this->db->from('z_area_executive');
        $this->db->where('executive', $username);
        $query = $this->db->get();
        return $query->result();
    }

    public function get_all_area() {
        $this->db->select('name');
        $this->db->from('area');
        $query = $this->db->get();
        return $query->result();
    }

    public function get_range($username) {
        $this->db->select('from,to');
        $this->db->from('z_executive_range');
        $this->db->where('executive', $username);
        $query = $this->db->get();
        return $query->result();
    }

    public function update_executive($data_executive, $data_area, $data_range, $username) {
        $this->db->trans_begin();
        $this->db->where('username', $username);
        $this->db->update('z_mobile_user', $data_executive);

        if ($data_area != null) {
            $this->db->delete('z_area_executive', array('executive' => $username));
            foreach ($data_area as $value) {
                $data = array('area' => $value, 'executive' => $data_executive['username']);
                $this->db->insert('z_area_executive', $data);
            }
        }
        if ($data_range != null) {
            $this->db->delete('z_executive_range', array('executive' => $username));
            foreach ($data_range as $value) {
                $this->db->insert('z_executive_range', $value);
            }
        }
        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
        } else {
            $this->db->trans_commit();
        }
    }

    public function delete_executive($username) {

        $this->db->delete('z_mobile_user', array('username' => $username));

        $this->db->delete('z_area_executive', array('executive' => $username));

        $this->db->delete('z_executive_range', array('executive' => $username));
    }

    public function get_username_exsist($username) {
        $this->db->select('username');
        $this->db->from('z_mobile_user');
        $this->db->where('username', $username);
        $query = $this->db->get();
        return $query->result();
    }

    public function get_center_by_area($area) {
        $this->db->select('name');
        $this->db->from('centre');
        $this->db->where('area', $area);
        $query = $this->db->get();
        return $query->result();
    }
    
    public function get_area_executive($executive) {
        $this->db->select('area.name');
        $this->db->from('z_area_executive');
        $this->db->join('area', 'area.name = z_area_executive.area');
        $this->db->where('z_area_executive.executive', $executive);
        $query = $this->db->get();
        return $query->result();
    }

    public function insert_supervisor($data_supervisor, $data_center, $data_executive_supervisor) {
        $this->db->trans_begin();
        $this->db->insert('z_mobile_user', $data_supervisor);

        if ($data_center != null) {
            foreach ($data_center as $value) {
                $this->db->insert('z_center_supervisor', $value);
            }
        }

        $this->db->insert('z_supervisor_executive', $data_executive_supervisor);
        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
        } else {
            $this->db->trans_commit();
        }
    }

    public function get_executive() {
        $this->db->select('username,firstname,lastname');
        $this->db->from('z_mobile_user');
        $this->db->where('type', 'Executive');
        $query = $this->db->get();
        return $query->result();
    }

    public function get_user_Supervisor() {
        $this->db->select('username,firstname,lastname,mobile,type');
        $this->db->from('z_mobile_user');
        $this->db->where('type', 'Supervisor');
        $query = $this->db->get();
        return $query->result();
    }

    public function get_center_supervisor($username) {
        $this->db->select('centre.area,centre.name');
        $this->db->from('z_center_supervisor');
        $this->db->join('centre', 'centre.name = z_center_supervisor.center');
        $this->db->where('z_center_supervisor.supervisor', $username);
        $query = $this->db->get();
        return $query->result();
    }

    public function get_executive_by_supervisor($username) {
        $this->db->select('z_mobile_user.firstname,z_mobile_user.lastname,z_mobile_user.username');
        $this->db->from(' z_mobile_user');
         $this->db->join('z_supervisor_executive', 'z_supervisor_executive.executive = z_mobile_user.username');
        $this->db->where('z_supervisor_executive.supervisor', $username);
        $query = $this->db->get();
        $user = $query->first_row('array');
        return $user;
    }

    public function get_centerlist($area) {
        $this->db->select('name');
        $this->db->from('centre');
        $this->db->where('area', $area);
        $query = $this->db->get();
        return $query->result();
    }

    public function update_supervisor($data_supervisor, $data_center, $data_executive_supervisor, $username) {
        $this->db->trans_begin();
        $this->db->where('username', $username);
        $this->db->update('z_mobile_user', $data_supervisor);

        if ($data_center !== null) {
            $this->db->delete('z_center_supervisor', array('supervisor' => $username));
            foreach ($data_center as $value) {
                $this->db->insert('z_center_supervisor', $value);
            }
        }
        $this->db->delete('z_supervisor_executive', array('supervisor' => $username));
        $this->db->insert('z_supervisor_executive', $data_executive_supervisor);
        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
        } else {
            $this->db->trans_commit();
        }
    }

    public function delete_supervisor($username) {

        $this->db->delete('z_mobile_user', array('username' => $username));

        $this->db->delete('z_center_supervisor', array('supervisor' => $username));

        $this->db->delete('z_supervisor_executive', array('supervisor' => $username));
    }

    public function exit_user_login($username, $password) {
        $this->db->select();
        $this->db->from('z_mobile_user');
        $this->db->where('username', $username);
        $this->db->where('password', $password);
        $this->db->where('type', 'ADMIN');
        $query = $this->db->get();
        $user = $query->first_row('array');
        return $user;
    }

    public function exit_username($username) {
        $this->db->select();
        $this->db->from('z_mobile_user');
        $this->db->where('username', $username);
        $this->db->where('type', 'ADMIN');
        $query = $this->db->get();
        $user = $query->first_row('array');
        return $user;
    }

    public function exit_password($username, $password) { 
        $this->db->select();
        $this->db->from('z_mobile_user');
        $this->db->where('username', $username);
        $this->db->where('password', $password);
        $this->db->where('type', 'ADMIN');
        $query = $this->db->get();
        $user = $query->first_row('array');
        return $user;
    }
    
    public function get_executive_area() {
        $this->db->select('area.name');
        $this->db->from('z_area_executive');
        $this->db->join('area', 'area.name = z_area_executive.area');
        $this->db->group_by("area.name"); 
        $query = $this->db->get();
        return $query->result();
    }
    
     public function get_validate_area($arr) {
        $this->db->select('area');
        $this->db->from('z_area_executive');
        $this->db->where_in('area', $arr);
        $query = $this->db->get();
        return $query->result();
    }
    
    public function get_supervisor_select_center($area) {
        $this->db->select('centre.name');
        $this->db->from('z_center_supervisor');
        $this->db->join('centre', 'centre.name = z_center_supervisor.center');
        $this->db->where('centre.area', $area);
        $query = $this->db->get();
        return $query->result();
    }
    
     public function get_validate_center($arr) {
        $this->db->select('center,supervisor');
        $this->db->from('z_center_supervisor');
        $this->db->where_in('center', $arr);
        $query = $this->db->get();
        return $query->result();
    }
    
    

}
