<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Farmer_modal
 *
 * @author user
 */
class Farmer_modal extends CI_Model {

    public function __construct() {
        $this->load->database();
    }

    public function exit_farmer($number) {
        $this->db->select();
        $this->db->from('farmer');
        $this->db->where('number', $number);
        $query = $this->db->get();
        $farmer = $query->first_row('array');
        return $farmer;
    }

    public function add_farmer($data) {
        $this->db->insert('farmer', $data);
    }

    public function edit_farmer($number, $data) {
        $this->db->where('number', $number);
        $this->db->update('farmer', $data);
    }

    public function delete_farmer($data) {
        $this->db->delete('farmer', $data);
    }

    public function get_all_farmer_list() {
        $this->db->select();
        $this->db->from('farmer');
        $query = $this->db->get();
        return $query->result();
    }

    public function get_max_farmer_id() {
//        $this->db->select_max('number');
//        $query = $this->db->get('farmer');
//        return $query->result();

        $SQL = "SELECT max(cast(number AS UNSIGNED)) as number FROM farmer ";
        $query = $this->db->query($SQL);
        return $query->result();
    }

    public function search_farmer_with_limit($limit, $data) {


        $this->db->select('number,farmer.name,surname,address,telephone,gender,nic,nationality,acherage,category,bank,branch,centre,acno,acholder,centre.area');
        $this->db->from('farmer');
        $this->db->join('centre', 'centre.name = farmer.centre');
        if (isset($data['number'])) {
            $this->db->like('farmer.number', $data['number'], 'both');
        }
        if (isset($data['name'])) {
            $this->db->like('farmer.name', $data['name'], 'both');
            $this->db->or_like('farmer.surname', $data['name'], 'both');
            $this->db->or_where("CONCAT(farmer.name, ' ', farmer.surname) LIKE '%" . $data['name'] . "%'", NULL, FALSE);
        }

        if (isset($data['nic'])) {
            $this->db->like('farmer.nic', $data['nic'], 'both');
        }
        $this->db->order_by("farmer.number", "desc");
        $this->db->limit($limit);
        $query = $this->db->get();
        return $query->result();
    }

    public function search_farmer_with_limit_count($data) {


        $this->db->select('number,farmer.name,surname,address,telephone,gender,nic,nationality,acherage,category,bank,branch,centre,acno,acholder,centre.area');
        $this->db->from('farmer');
        $this->db->join('centre', 'centre.name = farmer.centre');
        if (isset($data['number'])) {
            $this->db->like('farmer.number', $data['number'], 'both');
        }
        if (isset($data['name'])) {
            $this->db->like('farmer.name', $data['name'], 'both');
        }
        if (isset($data['nic'])) {
            $this->db->like('farmer.nic', $data['nic'], 'both');
        }
        $this->db->order_by("farmer.number", "desc");
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function search_farmer_without_limit($data) {
        $this->db->select('number,farmer.name,surname,address,telephone,gender,nic,nationality,acherage,category,bank,branch,centre,acno,acholder,centre.area');
        $this->db->from('farmer');
        $this->db->join('centre', 'centre.name = farmer.centre');
        if (isset($data['number'])) {
            $this->db->like('farmer.number', $data['number'], 'both');
        }
        if (isset($data['name'])) {
            $this->db->like('farmer.name', $data['name'], 'both');
            $this->db->or_like('farmer.surname', $data['name'], 'both');
            $this->db->or_where("CONCAT(farmer.name, ' ', farmer.surname) LIKE '%" . $data['name'] . "%'", NULL, FALSE);
        }
        if (isset($data['nic'])) {
            $this->db->like('farmer.nic', $data['nic'], 'both');
        }
        $this->db->order_by("farmer.number", "desc");
        $query = $this->db->get();
        return $query->result();
    }

    public function get_farmer_by_id($number) {
        $this->db->select('number,farmer.name,surname,address,telephone,gender,nic,nationality,acherage,category,bank,branch,centre,acno,acholder,centre.area');
        $this->db->from('farmer');
        $this->db->join('centre', 'centre.name = farmer.centre');
        $this->db->where('number', $number);
        $query = $this->db->get();
        $farmer = $query->first_row('array');
        return $farmer;
    }
    
     public function get_user_type($username) {
        $this->db->select('type');
        $this->db->from('z_mobile_user');
        $this->db->where('username', $username);
        $query = $this->db->get();
        $user = $query->first_row('array');
        return $user['type'];
    }
    
     public function range_validation($number,$executive) {
        $this->db->select('from,to');
        $this->db->from('z_executive_range');
        $this->db->where('from <=', (int)$number);
        $this->db->where('to >', (int)$number);
        $this->db->where('executive', $executive);
        $query = $this->db->get();
        $range = $query->first_row('array');
        return $range;
    }
    
    public function get_executive($username) {
        $this->db->select('executive');
        $this->db->from('z_supervisor_executive');
        $this->db->where('supervisor', $username);
        $query = $this->db->get();
        $user= $query->first_row('array');
        return $user['executive'];
    }

}
