<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Crop_modal
 *
 * @author user
 */
class Crop_modal extends CI_Model {

    public function __construct() {
        $this->load->database();
    }

    public function exit_crop($slipno) {
        $this->db->select();
        $this->db->from('crop');
        $this->db->where('slipno', $slipno);
        $query = $this->db->get();
        $farmer = $query->first_row('array');
        return $farmer;
    }

    public function add_crop($data) {
        $this->db->insert('crop', $data);
    }

    public function edit_crop($slipno, $data) {
        $this->db->where('slipno', $slipno);
        $this->db->update('crop', $data);
    }

    public function delete_crop($data) {
        $this->db->delete('crop', $data);
    }

    public function get_max_slip_no() {
        $this->db->select_max('slipno');
        $query = $this->db->get('crop');
        return $query->result();
    }

    public function search_crop_with_limit($limit, $slipno) {
        $this->db->select();
        $this->db->from('crop');
        $this->db->where('slipno', $slipno);
        $this->db->order_by("slipno", "desc");
        $this->db->limit($limit);
        $query = $this->db->get();
        return $query->result();
    }

    public function search_crop_with_limit_count($slipno) {
        $this->db->select();
        $this->db->from('crop');
        $this->db->where('slipno', $slipno);
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function search_crop($slipno) {
        $this->db->select();
        $this->db->from('crop');
        $this->db->where('slipno', $slipno);
        $this->db->order_by("slipno", "desc");
        $query = $this->db->get();
        return $query->result();
    }

    public function get_my_crop_list_with_limit($limit, $username) {
        $this->db->select();
        $this->db->from('crop');
        $this->db->where('username', $username);
        $this->db->order_by("slipno", "desc");
        $this->db->limit($limit);
        $query = $this->db->get();
        return $query->result();
    }

    public function get_my_crop_list_with_limit_count($username) {
        $this->db->select();
        $this->db->from('crop');
        $this->db->where('username', $username);
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function get_my_crop_list_without_limit($username) {
        $this->db->select();
        $this->db->from('crop');
        $this->db->where('username', $username);
        $this->db->order_by("slipno", "desc");
        $query = $this->db->get();
        return $query->result();
    }
    
     public function get_payemnt_result_crop($farmerno, $date) {
        $this->db->select();
        $this->db->from('payment');
        $this->db->where('farmerno', $farmerno);
        $this->db->where("DATE_FORMAT(start,'%Y/%m/%d') <= ", $date);
        $this->db->where("DATE_FORMAT(end,'%Y/%m/%d') >= ", $date);
        $query = $this->db->get();
        return $query->result();
    }
    
    public function search_crop_by_farmer_date($farmerno, $fromdate, $todate) {
        $this->db->select('slipno, farmerno, date, g1, g2, g3, g4, g5, g6, nettot as total');
        $this->db->from('crop');
        $this->db->where('farmerno', $farmerno);
        $this->db->where('date >=', $fromdate);
        $this->db->where('date <=', $todate);
        $this->db->order_by("slipno", "desc");
        $query = $this->db->get();

        return $query->result();
    }
    
    public function search_crop_total_by_farmer_date($farmerno, $fromdate, $todate) {
        $this->db->select('SUM(g1) as g1, SUM(g2) as g2, SUM(g3) as g3, SUM(g4) as g4, SUM(g5) as g5, SUM(g6) as g6, SUM(nettot) as total');
        $this->db->from('crop');
        $this->db->where('farmerno', $farmerno);
        $this->db->where('date >=', $fromdate);
        $this->db->where('date <=', $todate);
        $query = $this->db->get();
        $ret = $query->row();
        return (isset($ret)) ? $ret : null;
    }
    
    public function search_crop_by_center_date($center, $fromdate, $todate) {
        $this->db->select('slipno, farmerno, date, g1, g2, g3, g4, g5, g6, nettot as total');
        $this->db->from('crop');
        $this->db->where('centre', $center);
        $this->db->where('date >=', $fromdate);
        $this->db->where('date <=', $todate);
        $this->db->order_by("slipno", "desc");
        $query = $this->db->get();

        return $query->result();
    }
    
    public function search_crop_total_by_center_date($center, $fromdate, $todate) {
        $this->db->select('SUM(g1) as g1, SUM(g2) as g2, SUM(g3) as g3, SUM(g4) as g4, SUM(g5) as g5, SUM(g6) as g6, SUM(nettot) as total');
        $this->db->from('crop');
        $this->db->where('centre', $center);
        $this->db->where('date >=', $fromdate);
        $this->db->where('date <=', $todate);
        $query = $this->db->get();
        $ret = $query->row();
        return (isset($ret)) ? $ret : null;
    }
}


