<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Supervisor
 *
 * @author mahed
 */
class Supervisor extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('Mobileuser_modal');
        $this->load->helper(array('form', 'url', 'date'));
        $this->load->library('session');
    }

    public function create() {
        $session_data = $this->session->all_userdata();
        if (isset($session_data['nameheader'])) {
            $data['userheader'] = $session_data['nameheader'];
        } else {
            $data['userheader'] = '';
        }

        if (isset($session_data['username'])) {
            $username = $session_data['username'];
        } else {
            $username = '';
        }
        if ($username != null) {
            $data['area'] = $this->Mobileuser_modal->get_area();
            $data['executive'] = $this->Mobileuser_modal->get_executive();
            $data['suc_msg'] = $this->session->flashdata('create');
            $this->load->view('template/sidebar', $data);
            $this->load->view('template/topnavigation');
            $this->load->view('Supervisor/Supervisor_create', $data);
            $this->load->view('template/footer');
        } else {
            $data['error_msg_login'] = "You don't have authorization to access this page!";
            $this->load->view('login', $data);
        }
    }

    public function get_center_by_area() {

        $area = $this->input->post('area');
        $centerlist = json_decode($this->input->post('centerlist'));
        $data = $this->Mobileuser_modal->get_center_by_area($area);

        $center = array();
        foreach ($data as $row) {
            array_push($center, $row->name);
        }

        $diff_center1 = array_diff($center, $centerlist);

        $data_select_area = $this->Mobileuser_modal->get_supervisor_select_center($area);
        $center_select = array();
        foreach ($data_select_area as $row) {
            array_push($center_select, $row->name);
        }
        $diff_center2 = array_diff($diff_center1, $center_select);
        echo json_encode($diff_center2);
    }

    public function get_executive_area() {

        $executive = $this->input->post('executive');
        $data = $this->Mobileuser_modal->get_area_executive($executive);
        echo json_encode($data);
    }

    public function get_executive_area_edit() {

        $executive = $this->input->post('executive');

        $executive_area = $this->Mobileuser_modal->get_area_executive($executive);
        $data['area'] = $executive_area;

        $username = $this->input->post('username');
        $center_area = $this->Mobileuser_modal->get_center_supervisor($username);
        $data['details'] = array();
        $select_center = array();
        $center_select_list = array();
        $x = 0;
        foreach ($center_area as $row) {
            $area = $row->area;
            foreach ($executive_area as $row1) {
                $ex_area = $row1->name;
                if ($area == $ex_area) {
                    $center = $row->name;
                    array_push($center_select_list, $center);
                    $all_center_list = $this->Mobileuser_modal->get_centerlist($area);
                    $all_center = array();
                    foreach ($all_center_list as $row) {
                        array_push($all_center, $row->name);
                    }


                    $data_select_center = $this->Mobileuser_modal->get_supervisor_select_center($area);
                    $center_select = array();
                    foreach ($data_select_center as $row) {
                        array_push($center_select, $row->name);
                    }

                    $this_center = array();
                    array_push($this_center, $center);

                    array_push($select_center, $center);

                    $diff1 = array_diff($center_select, $this_center);
                    $center_list = array_diff($all_center, $diff1);

                    $data['details'][$x] = array('area' => $area, 'center' => $center, 'centerlist' => $center_list);

                    $x++;
                }
            }
        }

        $data['center'] = json_encode($select_center);


        echo json_encode($data);
    }

    public function created() {
        $session_data = $this->session->all_userdata();
        if (isset($session_data['nameheader'])) {
            $data['userheader'] = $session_data['nameheader'];
        } else {
            $data['userheader'] = '';
        }

        if (isset($session_data['username'])) {
            $username = $session_data['username'];
        } else {
            $username = '';
        }
        if ($username != null) {
            $data_supervisor['username'] = $this->input->post('username');
            $data_supervisor['firstname'] = $this->input->post('fristname');
            $data_supervisor['lastname'] = $this->input->post('lastname');
            $data_supervisor['mobile'] = $this->input->post('mobile');
            $data_supervisor['type'] = 'Supervisor';
            $data_supervisor['password'] = md5($this->input->post('password'));
            $executive = $this->input->post('executive');

            $data_center = array();
            $username = $this->input->post('username');
            for ($i = 0; $i < 6; $i++) {
                $center = $this->input->post('center' . strval($i + 1));
                if ($center != null) {
                    $data_center[$i] = array('center' => $center, 'supervisor' => $username);
                }
            }

            $data_executive_supervisor = array('supervisor' => $username, 'executive' => $executive);

            $this->Mobileuser_modal->insert_supervisor($data_supervisor, $data_center, $data_executive_supervisor);
            $this->session->set_flashdata('create', "Supervisor added successfully.");
            redirect(base_url() . 'index.php/Supervisor/create');
        } else {
            $data['error_msg_login'] = "You don't have authorization to access this page!";
            $this->load->view('login', $data);
        }
    }

    public function view() {
        $session_data = $this->session->all_userdata();
        if (isset($session_data['nameheader'])) {
            $data['userheader'] = $session_data['nameheader'];
        } else {
            $data['userheader'] = '';
        }

        if (isset($session_data['username'])) {
            $username = $session_data['username'];
        } else {
            $username = '';
        }
        if ($username != null) {
            $update_message = $this->session->flashdata('update');
            $delete_message = $this->session->flashdata('delete');
            if ($update_message != null) {
                $data['suc_msg'] = $this->session->flashdata('update');
            } else if ($delete_message != null) {
                $data['suc_msg'] = $this->session->flashdata('delete');
            }
            $data['user'] = $this->Mobileuser_modal->get_user_Supervisor();
            $this->load->view('template/sidebar', $data);
            $this->load->view('template/topnavigation');
            $this->load->view('Supervisor/Supervisor_view');
            $this->load->view('template/footer');
        } else {
            $data['error_msg_login'] = "You don't have authorization to access this page!";
            $this->load->view('login', $data);
        }
    }

    public function viewed() {
        $session_data = $this->session->all_userdata();
        if (isset($session_data['nameheader'])) {
            $data['userheader'] = $session_data['nameheader'];
        } else {
            $data['userheader'] = '';
        }

        if (isset($session_data['username'])) {
            $username = $session_data['username'];
        } else {
            $username = '';
        }
        if ($username != null) {
            $username = $this->input->post('username');
            $data['user'] = $this->Mobileuser_modal->get_user_one($username);
            $data['center'] = $this->Mobileuser_modal->get_center_supervisor($username);
            $executive = $this->Mobileuser_modal->get_executive_by_supervisor($username);


            $data['executive'] = $executive['firstname'] . " " . $executive['lastname'];

            $this->load->view('template/sidebar', $data);
            $this->load->view('template/topnavigation');
            $this->load->view('Supervisor/Supervisor_viewed');
            $this->load->view('template/footer');
        } else {
            $data['error_msg_login'] = "You don't have authorization to access this page!";
            $this->load->view('login', $data);
        }
    }

    public function edit() {
        $session_data = $this->session->all_userdata();
        if (isset($session_data['nameheader'])) {
            $data['userheader'] = $session_data['nameheader'];
        } else {
            $data['userheader'] = '';
        }

        if (isset($session_data['username'])) {
            $username = $session_data['username'];
        } else {
            $username = '';
        }
        if ($username != null) {
            $username = $this->input->post('username');
            $data['user'] = $this->Mobileuser_modal->get_user_one($username);

            $data['all_executive'] = $this->Mobileuser_modal->get_executive();
            $data['executive'] = $this->Mobileuser_modal->get_executive_by_supervisor($username);
            $data['area'] = $this->Mobileuser_modal->get_area();


            $center_area = $this->Mobileuser_modal->get_center_supervisor($username);
            $data['center'] = array();
            $center_select_list = array();
            $x = 0;
            foreach ($center_area as $row) {
                $area = $row->area;
                $center = $row->name;
                array_push($center_select_list, $center);
                $all_center_list = $this->Mobileuser_modal->get_centerlist($area);
                $all_center = array();
                foreach ($all_center_list as $row) {
                    array_push($all_center, $row->name);
                }


                $data_select_center = $this->Mobileuser_modal->get_supervisor_select_center($area);
                $center_select = array();
                foreach ($data_select_center as $row) {
                    array_push($center_select, $row->name);
                }

                $this_center = array();
                array_push($this_center, $center);

                $diff1 = array_diff($center_select, $this_center);
                $center_list = array_diff($all_center, $diff1);

                $data['center'][$x] = array('area' => $area, 'center' => $center, 'centerlist' => $center_list);

                $x++;
            }
            $data['center_select_list'] = json_encode($center_select_list);
            $this->load->view('template/sidebar', $data);
            $this->load->view('template/topnavigation');
            $this->load->view('Supervisor/Supervisor_edit');
            $this->load->view('template/footer');
        } else {
            $data['error_msg_login'] = "You don't have authorization to access this page!";
            $this->load->view('login', $data);
        }
    }

    public function edited() {
        $session_data = $this->session->all_userdata();
        if (isset($session_data['nameheader'])) {
            $data['userheader'] = $session_data['nameheader'];
        } else {
            $data['userheader'] = '';
        }

        if (isset($session_data['username'])) {
            $name = $session_data['username'];
        } else {
            $name = '';
        }
        if ($name != null) {

            $username = $this->input->post('username');
            $data_supervisor['firstname'] = $this->input->post('fristname');
            $data_supervisor['lastname'] = $this->input->post('lastname');
            $data_supervisor['mobile'] = $this->input->post('mobile');
            $executive = $this->input->post('executive');

            $data_center = array();
            for ($i = 0; $i < 6; $i++) {
                $center = $this->input->post('center' . strval($i + 1));
                if ($center != null) {
                    $data_center[$i] = array('center' => $center, 'supervisor' => $username);
                }
            }

            $data_executive_supervisor = array('supervisor' => $username, 'executive' => $executive);

            $this->Mobileuser_modal->update_supervisor($data_supervisor, $data_center, $data_executive_supervisor, $username);
            $this->session->set_flashdata('update', "Supervisor updated successfully.");
            redirect(base_url() . 'index.php/Supervisor/view');
        } else {
            $data['error_msg_login'] = "You don't have authorization to access this page!";
            $this->load->view('login', $data);
        }
    }

    public function delete() {
        $session_data = $this->session->all_userdata();
        if (isset($session_data['username'])) {
            $name = $session_data['username'];
        } else {
            $name = '';
        }
        if ($name != null) {
            $username = $this->input->post('username');
            $this->Mobileuser_modal->delete_supervisor($username);
            $data['STATUS'] = 'TRUE';
            $this->session->set_flashdata('delete', "Supervisor deleted successfully.");
        }
        echo json_encode($data);
    }

    public function center_exist() {

        $center = json_decode($this->input->post('centerlist'));
        $data_exist = $this->Mobileuser_modal->get_validate_center($center);
        if ($data_exist != null) {
            $data['STATUS'] = 'FALSE';
        } else {
            $data['STATUS'] = 'TRUE';
        }
        echo json_encode($data);
    }

    public function center_exist_supervisor_edit() {

        $center = json_decode($this->input->post('centerlist'));
        $username = $this->input->post('username');
        $data_exist = $this->Mobileuser_modal->get_validate_center($center);

        $center_list = array();
        foreach ($data_exist as $row) {
            $supervisor = $row->supervisor;
            $center = $row->center;
            if ($supervisor != $username) {
                array_push($center_list, $center);
            }
        }
        if ($center_list != null) {
            $data['STATUS'] = 'FALSE';
        } else {
            $data['STATUS'] = 'TRUE';
        }
        echo json_encode($data);
    }

}
