<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Mobileuser
 *
 * @author mahed
 */
require APPPATH . '/libraries/REST_Controller.php';

class Mobileuser extends REST_Controller {

    function __construct() {
        parent::__construct();
        $this->load->database();
        $this->load->model('Mobileuser_modal');
        $this->load->model('Token_modal');
    }

    public function adduser_post() {
        $headers = $this->input->request_headers();
        $valid = $this->Token_modal->exit_token($headers['Token']);
        if ($valid != null) {
            header('Content-type: application/json');
            $object = json_decode(file_get_contents('php://input'), true);
            $data = $object['AddUserRequest']['User'];
            $data['added_by'] = $valid['username'];
            $user = $this->Mobileuser_modal->exit_user($object['AddUserRequest']['User']['username']);
            if ($user != null) {
                $message = array("Status" => "1003",
                    "Message" => "Username already exist.");
                $response_message = array("AddUserResponse" => $message);
                $this->response($response_message);
            } else {
                $data['password']= md5($data['password']);
                $this->Mobileuser_modal->add_user($data);
                $message = array("Status" => "200",
                    "Message" => "User added successfully!");
                $response_message = array("AddUserResponse" => $message);
                $this->response($response_message);
            }
        } else {
            $message = array("Status" => "1002",
                "Message" => "Invalid token");
            $response_message = array("AddUserResponse" => $message);
            $this->response($response_message);
        }
    }

    public function edituser_post() {
        $headers = $this->input->request_headers();
        $valid = $this->Token_modal->exit_token($headers['Token']);
        if ($valid != null) {
            header('Content-type: application/json');
            $object = json_decode(file_get_contents('php://input'), true);
            $data = $object['EditUserRequest']['User'];
            $data['added_by'] = $valid['username'];
            $user = $this->Mobileuser_modal->exit_user($object['EditUserRequest']['User']['username']);
            if ($user != null) {
                 $data['password']= md5($data['password']);
                $this->Mobileuser_modal->edit_user($object['EditUserRequest']['User']['username'], $data);
                $message = array("Status" => "200",
                    "Message" => "User details successfully updated.");
                $response_message = array("EditUserResponse" => $message);
                $this->response($response_message);
            } else {
                $message = array("Status" => "1004",
                    "Message" => "Internal error. User details not updated.");
                $response_message = array("EditUserResponse" => $message);
                $this->response($response_message);
            }
        } else {
            $message = array("Status" => "1002",
                "Message" => "Invalid token");
            $response_message = array("EditUserResponse" => $message);
            $this->response($response_message);
        }
    }
    
    public function deleteuser_post() {
        $headers = $this->input->request_headers();
        $valid = $this->Token_modal->exit_token($headers['Token']);
        if ($valid != null) {
            header('Content-type: application/json');
            $object = json_decode(file_get_contents('php://input'), true);
            $user= $this->Mobileuser_modal->exit_user($object['DeleteUserRequest']['User']['username']);
            if ($user != null) {
                $data = array("username" => $object['DeleteUserRequest']['User']['username']);
                $this->Mobileuser_modal->delete_user($data);
                $message = array("Status" => "200",
                    "Message" => " User deleted successfully.");
                $response_message = array("DeleteUserResponse" => $message);
                $this->response($response_message);
            } else {
                $message = array("Status" => "1004",
                    "Message" => "Internal error. User not deleted");
                $response_message = array("DeleteUserResponse" => $message);
                $this->response($response_message);
            }
        } else {
            $message = array("Status" => "1002",
                "Message" => "Invalid token");
            $response_message = array("DeleteUserResponse" => $message);
            $this->response($response_message);
        }
    }
    
    
    public function usernameavilability_post() {
        $headers = $this->input->request_headers();
        $valid = $this->Token_modal->exit_token($headers['Token']);
        if ($valid != null) {
            header('Content-type: application/json');
            $object = json_decode(file_get_contents('php://input'), true);
            $user = $this->Mobileuser_modal->exit_user($object['UsernameAvailabilityRequest']['User']['username']);
            if ($user != null) {
                $message = array("Status" => "1003",
                    "Availability" => 0);
                $response_message = array("UsernameAvailabilityResponse" => $message);
                $this->response($response_message);
            } else {
                $message = array("Status" => "200",
                    "Availability" => 1);
                $response_message = array("UsernameAvailabilityResponse" => $message);
                $this->response($response_message);
            }
        } else {
            $message = array("Status" => "1002",
                "Message" => "Invalid token");
            $response_message = array("UsernameAvailabilityResponse" => $message);
            $this->response($response_message);
        }
    }
    
     public function passwordreset_post() {
        $headers = $this->input->request_headers();
        $valid = $this->Token_modal->exit_token($headers['Token']);
        if ($valid != null) {
            header('Content-type: application/json');
            $object = json_decode(file_get_contents('php://input'), true);
            $current_password = $object['ResetUserPasswordRequest']['User']['currentpassword'];
            $new_password = $object['ResetUserPasswordRequest']['User']['newpassword'];
            $user = $this->Mobileuser_modal->exit_current_password(md5($current_password),$valid['username']);
            if ($user != null) {
                $this->Mobileuser_modal->edit_password($new_password,$valid['username']);
                $message = array("Status" => "200",
                    "Message" => "Password updated successfully.");
                $response_message = array("ResetUserPasswordResponse" => $message);
                $this->response($response_message);
            } else {
                $message = array("Status" => "1001",
                    "Message" => "Password incorrect.");
                $response_message = array("ResetUserPasswordResponse" => $message);
                $this->response($response_message);
            }
        } else {
            $message = array("Status" => "1002",
                "Message" => "Invalid token");
            $response_message = array("ResetUserPasswordResponse" => $message);
            $this->response($response_message);
        }
    }

}
