<?php

class Login extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('Mobileuser_modal');
        $this->load->helper(array('form', 'url', 'date'));
        $this->load->library('session');
    }

    public function index() {
        $this->load->view('login');
    }

    public function validate_user() {

        $username = $this->input->post('username');
        $password = md5($this->input->post('password'));

        $data = $this->Mobileuser_modal->exit_user_login($username, $password);
        $name = $data['firstname'] . '  ' . $data['lastname'];


        if ($data != null) {
            $this->session->set_userdata('nameheader', $name);
            $this->session->set_userdata('username', $username);
            redirect(base_url() . 'index.php/Executive/view');
        } else {
            $data['error_login'] = 'INVALIDLOGIN';
            $data_email = $this->Mobileuser_modal->exit_username($username);
            $data_password = $this->Mobileuser_modal->exit_password($username, $password);
            if (!$data_email) {
                $data['error_msg_email'] = 'Invalid Email.Please try again.';
            } else if (!$data_password) {
                $data['error_msg_password'] = 'Invalid Password.Please try again.';
            }

            $this->load->view('login', $data);
        }
    }
    
     public function logout() {

        $this->session->unset_userdata('nameheader');
        $this->session->unset_userdata('username');

        $data['success_msg_login'] = "You've been logged out successfully.";
        $this->load->view('login', $data);
    }

}
