<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Item
 *
 * @author user
 */
require APPPATH . '/libraries/REST_Controller.php';

class Item extends REST_Controller {

    function __construct() {
        parent::__construct();
        $this->load->database();
        $this->load->model('Item_modal');
        $this->load->model('Token_modal');
    }

    public function getitemlist_post() {
        $headers = $this->input->request_headers();
        $valid = $this->Token_modal->exit_token($headers['Token']);
        if ($valid != null) {
            header('Content-type: application/json');
            $item = $this->Item_modal->get_item_list();
            $item_list = array("Item" => $item);
            $message = array("Status" => "200",
                "ItemList" => $item_list);
            $response_message = array("GetItemListResponse" => $message);
            $this->response($response_message);
        } else {
            $message = array("Status" => "1002",
                "Message" => "Invalid token");
            $response_message = array("GetItemListResponse" => $message);
            $this->response($response_message);
        }
    }

    public function getitembyitemid_post() {
        $headers = $this->input->request_headers();
        $valid = $this->Token_modal->exit_token($headers['Token']);
        if ($valid != null) {
            header('Content-type: application/json');
            $object = json_decode(file_get_contents('php://input'), true);
            $itemId = $object['GetItemByIdRequest']['Item']['code'];

            $item = $this->Item_modal->get_item_list_by_id($itemId);
            if ($item != null) {
                $message = array("Status" => "200",
                    "Item" => $item);
                $response_message = array("GetItemByIdResponse" => $message);
                $this->response($response_message);
            } else {
                $message = array("Status" => "1005",
                    "Message" => 'Invalid Item Code.');
                $response_message = array("GetItemByIdResponse" => $message);
                $this->response($response_message);
            }
        } else {
            $message = array("Status" => "1002",
                "Message" => "Invalid token");
            $response_message = array("GetItemListResponse" => $message);
            $this->response($response_message);
        }
    }

}
