<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Issue
 *
 * @author Rasika
 */
require APPPATH . '/libraries/REST_Controller.php';

class Issue extends REST_Controller {

    function __construct() {
        parent::__construct();
        $this->load->database();
        $this->load->model('Issue_modal');
        $this->load->model('Token_modal');
        $this->load->model('User_modal');
    }

    public function addissue_post() {
        $headers = $this->input->request_headers();
        $valid = $this->Token_modal->exit_token($headers['Token']);
        if ($valid != null) {
            header('Content-type: application/json');
            $object = json_decode(file_get_contents('php://input'), true);
            $data = $object['AddIssueRequest']['Issue'];
            $data_response = $object['AddIssueRequest']['Issue'];
            $area = $this->Issue_modal->get_area($object['AddIssueRequest']['Issue']['centre']);
            $data_response['area'] = $area;
            $data['username'] = $valid['username'];
            $issue = $this->Issue_modal->exit_issue($object['AddIssueRequest']['Issue']['recno']);
            if ($issue != null) {
                $message = array("Status" => "1003",
                    "Message" => "Issue already exist.");
                $response_message = array("AddIssueResponse" => $message);
                $this->response($response_message);
            } else {
                $issue_data['username'] = $data['username'];
                $issue_data['recno'] = $data['recno'];
                $issue_data['season'] = $data['season'];
                $issue_data['farmerno'] = $data['farmerno'];
                $issue_data['name'] = $data['name'];
                $issue_data['centre'] = $data['centre'];
                $issue_data['date'] = $data['date'];
                $issue_data['total'] = $data['total'];

                $this->Issue_modal->add_issue($issue_data);
                $item_list = $data['ItemIssue']['Item'];
                $arrlength = count($item_list);
                for ($x = 0; $x < $arrlength; $x++) {
                    $data = $item_list[$x];
                    $this->Issue_modal->add_item_issue($data);
                }
                $message = array("Status" => "200",
                    "Message" => "Issue added successfully!",
                    "Issue" => $data_response);
                $response_message = array("AddIssueResponse" => $message);
                $this->response($response_message);
            }
        } else {
            $message = array("Status" => "1002",
                "Message" => "Invalid token");
            $response_message = array("AddIssueResponse" => $message);
            $this->response($response_message);
        }
    }

    public function editissue_post() {
        $headers = $this->input->request_headers();
        $valid = $this->Token_modal->exit_token($headers['Token']);
        if ($valid != null) {
            header('Content-type: application/json');
            $object = json_decode(file_get_contents('php://input'), true);
            $data = $object['EditIssueRequest']['Issue'];
            $data_response = $object['EditIssueRequest']['Issue'];
            $area = $this->Issue_modal->get_area($data['centre']);
            $data_response['area'] = $area;
            $data['username'] = $valid['username'];
            $issue = $this->Issue_modal->exit_issue($data['recno']);
            if ($issue != null) {

                $issue_data['username'] = $data['username'];
                $issue_data['recno'] = $data['recno'];
                $issue_data['season'] = $data['season'];
                $issue_data['farmerno'] = $data['farmerno'];
                $issue_data['name'] = $data['name'];
                $issue_data['centre'] = $data['centre'];
                $issue_data['date'] = $data['date'];
                $issue_data['total'] = $data['total'];


                $this->Issue_modal->edit_issue($data['recno'], $issue_data);
                $item_list = $data['ItemIssue']['Item'];
                $arrlength = count($item_list);
                $data_recno = array("recno" => $data['recno']);
                $this->Issue_modal->delete_item_issue($data_recno);
                for ($x = 0; $x < $arrlength; $x++) {
                    $data1 = $item_list[$x];
                    $data1['recno'] = $data['recno'];
                    $this->Issue_modal->add_item_issue($data1);
                }
                $message = array("Status" => "200",
                    "Message" => "Issue details successfully updated.",
                    "Issue" => $data_response);
                $response_message = array("EditIssueResponse" => $message);
                $this->response($response_message);
            } else {
                $message = array("Status" => "1004",
                    "Message" => "Internal error. Issue details not updated.");
                $response_message = array("EditIssueResponse" => $message);
                $this->response($response_message);
            }
        } else {
            $message = array("Status" => "1002",
                "Message" => "Invalid token");
            $response_message = array("EditIssueResponse" => $message);
            $this->response($response_message);
        }
    }

    public function deleteissue_post() {
        $headers = $this->input->request_headers();
        $valid = $this->Token_modal->exit_token($headers['Token']);
        if ($valid != null) {
            header('Content-type: application/json');
            $object = json_decode(file_get_contents('php://input'), true);
            $issue = $this->Issue_modal->exit_issue($object['DeleteIssueRequest']['Issue']['recno']);
            if ($issue != null) {
                $data = array("recno" => $object['DeleteIssueRequest']['Issue']['recno']);
                $this->Issue_modal->delete_issue($data);
                $this->Issue_modal->delete_item_issue($data);
                $message = array("Status" => "200",
                    "Message" => "Issue deleted successfully.");
                $response_message = array("DeleteIssueResponse" => $message);
                $this->response($response_message);
            } else {
                $message = array("Status" => "1004",
                    "Message" => "Internal error. Issue not deleted.");
                $response_message = array("DeleteIssueResponse" => $message);
                $this->response($response_message);
            }
        } else {
            $message = array("Status" => "1002",
                "Message" => "Invalid token");
            $response_message = array("DeleteIssueResponse" => $message);
            $this->response($response_message);
        }
    }

    public function getnextreceiptno_post() {
        $headers = $this->input->request_headers();
        $valid = $this->Token_modal->exit_token($headers['Token']);
        if ($valid != null) {
            $max_receipt_no_list = $this->Issue_modal->get_max_receipt_no();

            foreach ($max_receipt_no_list as $key) {
                $max_receipt_no = $key->recno;
            }
            $next_receipt_no = intval($max_receipt_no) + 1;
            $message = array("Status" => "200",
                "number" => $next_receipt_no);

            $response_message = array("GetNextIssueReceiptNoResponse" => $message);
            $this->response($response_message);
        } else {
            $message = array("Status" => "1002",
                "Message" => "Invalid token");
            $response_message = array("GetNextIssueReceiptNoResponse" => $message);
            $this->response($response_message);
        }
    }

    public function searchissuewithlimit_post() {
        $headers = $this->input->request_headers();
        $valid = $this->Token_modal->exit_token($headers['Token']);
        if ($valid != null) {
            header('Content-type: application/json');
            $object = json_decode(file_get_contents('php://input'), true);

            $limit = $object['SearchIssueByIdRequest']['Parameters']['Limit'];
            $recno = $object['SearchIssueByIdRequest']['Issue']['recno'];

            $issue_data = $this->Issue_modal->search_issue_with_limit($limit, $recno);
            $count = $this->Issue_modal->search_issue_with_limit_count($recno);
            $user_type = $this->Issue_modal->get_user_type($valid['username']);
            foreach ($issue_data as $key) {
                $recno = $key->recno;
                $item_data = $this->Issue_modal->search_issue_item_with_limit($recno);
                $data_item['Item'] = $item_data;
                $farmerno = $key->farmerno;
                $date = $key->date;
                $payement = $this->Issue_modal->get_payemnt_result($farmerno, $date);
                if ($payement != null) {
                    $key->processed = 1;
                } else {
                    $key->processed = 0;
                }
                if ($user_type == 'Supervisor') {
                    $key->updatable = 0;
                } else {
                    $supervisor_exit = $this->Issue_modal->get_my_supervisor($valid['username'], $key->username);
                    if (($valid['username'] == $key->username) && $payement == null) {
                        $key->updatable = 1;
                    } else if ($supervisor_exit != null && $payement == null) {
                        $key->updatable = 1;
                    } else {
                        $key->updatable = 0;
                    }
                }
                $key->ItemIssue = $data_item;
            }
            if ($count > $limit) {
                $data_issue['Issue'] = $issue_data;
                $message = array("Status" => "200",
                    "MoreResultsExist" => "Y",
                    "IssueList" => $data_issue);
            } else {
                $data_issue['Issue'] = $issue_data;
                $message = array("Status" => "200",
                    "MoreResultsExist" => "N",
                    "IssueList" => $data_issue);
            }

            $response_message = array("SearchIssueByIdResponse" => $message);
            $this->response($response_message);
        } else {
            $message = array("Status" => "1002",
                "Message" => "Invalid token");
            $response_message = array("SearchIssueByIdResponse" => $message);
            $this->response($response_message);
        }
    }

    public function searchissuewithoutlimit_post() {
        $headers = $this->input->request_headers();
        $valid = $this->Token_modal->exit_token($headers['Token']);
        if ($valid != null) {
            header('Content-type: application/json');
            $object = json_decode(file_get_contents('php://input'), true);

            $recno = $object['SearchIssueByIdRequest']['Issue']['recno'];

            $user_type = $this->Issue_modal->get_user_type($valid['username']);
            $issue_data = $this->Issue_modal->search_issue_without_limit($recno);
            foreach ($issue_data as $key) {
                $recno = $key->recno;
                $item_data = $this->Issue_modal->search_issue_item_with_limit($recno);
                $data_item['Item'] = $item_data;
                $farmerno = $key->farmerno;
                $date = $key->date;
                $payement = $this->Issue_modal->get_payemnt_result($farmerno, $date);
                if ($payement != null) {
                    $key->processed = 1;
                } else {
                    $key->processed = 0;
                }
                if ($user_type == 'Supervisor') {
                    $key->updatable = 0;
                } else {
                    $supervisor_exit = $this->Issue_modal->get_my_supervisor($valid['username'], $key->username);
                    if (($valid['username'] == $key->username) && $payement == null) {
                        $key->updatable = 1;
                    } else if ($supervisor_exit != null && $payement == null) {
                        $key->updatable = 1;
                    } else {
                        $key->updatable = 0;
                    }
                }
                $key->ItemIssue = $data_item;
            }
            $data_issue['Issue'] = $issue_data;
            $message = array("Status" => "200",
                "IssueList" => $data_issue);
            $response_message = array("SearchIssueByIdResponse" => $message);
            $this->response($response_message);
        } else {
            $message = array("Status" => "1002",
                "Message" => "Invalid token");
            $response_message = array("SearchIssueByIdResponse" => $message);
            $this->response($response_message);
        }
    }

    public function getmyissuelistwithlimit_post() {
        $headers = $this->input->request_headers();
        $valid = $this->Token_modal->exit_token($headers['Token']);
        if ($valid != null) {
            header('Content-type: application/json');
            $object = json_decode(file_get_contents('php://input'), true);
            $limit = $object['GetMyIssueListRequest']['Parameters']['Limit'];

            $username = $this->User_modal->get_username($headers['Token']);
            $issue_list = $this->Issue_modal->get_my_issue_list_with_limit($limit, $username);
            $user_type = $this->Issue_modal->get_user_type($valid['username']);
            foreach ($issue_list as $key) {
                $recno = $key->recno;
                $item_data = $this->Issue_modal->search_issue_item_with_limit($recno);
                $data_item['Item'] = $item_data;
                $farmerno = $key->farmerno;
                $date = $key->date;
                $payement = $this->Issue_modal->get_payemnt_result($farmerno, $date);
                if ($payement != null) {
                    $key->processed = 1;
                } else {
                    $key->processed = 0;
                }
                if ($user_type == 'Supervisor') {
                    $key->updatable = 0;
                } else {
                    $supervisor_exit = $this->Issue_modal->get_my_supervisor($valid['username'], $key->username);
                    if (($valid['username'] == $key->username) && $payement == null) {
                        $key->updatable = 1;
                    } else if ($supervisor_exit != null && $payement == null) {
                        $key->updatable = 1;
                    } else {
                        $key->updatable = 0;
                    }
                }
                $key->ItemIssue = $data_item;
            }

            $count = $this->Issue_modal->get_my_issue_list_with_limit_count($username);
            if ($count > $limit) {
                $data_issue['Issue'] = $issue_list;
                $message = array("Status" => "200",
                    "MoreResultsExist" => "Y",
                    "IssueList" => $data_issue);
            } else {
                $data_issue['Issue'] = $issue_list;
                $message = array("Status" => "200",
                    "MoreResultsExist" => "N",
                    "IssueList" => $data_issue);
            }

            $response_message = array("GetMyIssueListResponse" => $message);

            $this->response($response_message);
        } else {
            $message = array("Status" => "1002",
                "Message" => "Invalid token");
            $response_message = array("GetMyIssueListResponse" => $message);
            $this->response($response_message);
        }
    }

    public function getmyissuelistwithoutlimit_get() {
        $headers = $this->input->request_headers();
        $valid = $this->Token_modal->exit_token($headers['Token']);
        if ($valid != null) {

            $username = $this->User_modal->get_username($headers['Token']);
            $issue_list = $this->Issue_modal->get_my_issue_list_without_limit($username);
            $user_type = $this->Issue_modal->get_user_type($valid['username']);
            foreach ($issue_list as $key) {
                $recno = $key->recno;
                $item_data = $this->Issue_modal->search_issue_item_with_limit($recno);
                $data_item['Item'] = $item_data;
                $farmerno = $key->farmerno;
                $date = $key->date;
                $payement = $this->Issue_modal->get_payemnt_result($farmerno, $date);
                if ($payement != null) {
                    $key->processed = 1;
                } else {
                    $key->processed = 0;
                }
                if ($user_type == 'Supervisor') {
                    $key->updatable = 0;
                } else {
                    $supervisor_exit = $this->Issue_modal->get_my_supervisor($valid['username'], $key->username);
                    if (($valid['username'] == $key->username) && $payement == null) {
                        $key->updatable = 1;
                    } else if ($supervisor_exit != null && $payement == null) {
                        $key->updatable = 1;
                    } else {
                        $key->updatable = 0;
                    }
                }
                $key->ItemIssue = $data_item;
            }
            $data_issue['Issue'] = $issue_list;
            $message = array("Status" => "200",
                "IssueList" => $data_issue);
            $response_message = array("GetMyIssueListResponse" => $message);

            $this->response($response_message);
        } else {
            $message = array("Status" => "1002",
                "Message" => "Invalid token");
            $response_message = array("GetMyIssueListResponse" => $message);
            $this->response($response_message);
        }
    }

    public function getissuebyid_post() {
        $headers = $this->input->request_headers();
        $valid = $this->Token_modal->exit_token($headers['Token']);
        if ($valid != null) {
            header('Content-type: application/json');
            $object = json_decode(file_get_contents('php://input'), true);

            $recno = $object['GetIssueByIdRequest']['Issue']['recno'];

            $issue_list = $this->Issue_modal->get_issue_by_id_list($recno);
            $user_type = $this->Issue_modal->get_user_type($valid['username']);
            foreach ($issue_list as $key) {
                $recno = $key->recno;
                $item_data = $this->Issue_modal->search_issue_item_with_limit($recno);
                $data_item['Item'] = $item_data;
                $farmerno = $key->farmerno;
                $date = $key->date;
                $payement = $this->Issue_modal->get_payemnt_result($farmerno, $date);
                if ($payement != null) {
                    $key->processed = 1;
                } else {
                    $key->processed = 0;
                }
                if ($user_type == 'Supervisor') {
                    $key->updatable = 0;
                } else {
                    $supervisor_exit = $this->Issue_modal->get_my_supervisor($valid['username'], $key->username);
                    if (($valid['username'] == $key->username) && $payement == null) {
                        $key->updatable = 1;
                    } else if ($supervisor_exit != null && $payement == null) {
                        $key->updatable = 1;
                    } else {
                        $key->updatable = 0;
                    }
                }
                $key->ItemIssue = $data_item;
            }

//            $data_issue['Issue'] = $issue_list;
            $message = array("Status" => "200",
                "Issue" => $issue_list);
            $response_message = array("GetIssueByIdResponse" => $message);

            $this->response($response_message);
        } else {
            $message = array("Status" => "1002",
                "Message" => "Invalid token");
            $response_message = array("DeleteIssueResponse" => $message);
            $this->response($response_message);
        }
    }
    
    public function farmerreport_post() {
        $headers = $this->input->request_headers();
        $valid = $this->Token_modal->exit_token($headers['Token']);
        if ($valid != null) {
            header('Content-type: application/json');
            $object = json_decode(file_get_contents('php://input'), true);

            $fromdate = $object['GetFarmerIssueRequest']['Parameters']['fromdate'];
            $todate = $object['GetFarmerIssueRequest']['Parameters']['todate'];
            $farmerno = $object['GetFarmerIssueRequest']['Farmer']['number'];
            
            $issue_data = $this->Issue_modal->search_issue_by_farmer_date($farmerno, $fromdate, $todate);
            $data_issue['Issue'] = $issue_data;
            $message = array("Status" => "200",
                "IssueList" => $data_issue);
            $response_message = array("SearchIssueByIdResponse" => $message);
            $this->response($response_message);
        } else {
            $message = array("Status" => "1002",
                "Message" => "Invalid token");
            $response_message = array("SearchIssueByIdResponse" => $message);
            $this->response($response_message);
        }
    }
    
    public function farmerreptotal_post() {
        $headers = $this->input->request_headers();
        $valid = $this->Token_modal->exit_token($headers['Token']);
        if ($valid != null) {
            header('Content-type: application/json');
            $object = json_decode(file_get_contents('php://input'), true);

            $fromdate = $object['GetFarmerIssueTotRequest']['Parameters']['fromdate'];
            $todate = $object['GetFarmerIssueTotRequest']['Parameters']['todate'];
            $farmerno = $object['GetFarmerIssueTotRequest']['Farmer']['number'];
            
            $issue_data = $this->Issue_modal->search_issue_by_farmer_date_total($farmerno, $fromdate, $todate);
            $total = $issue_data[0]->total;
            if($total == null){
                $total  = 0;
            }
            $message = array("Status" => "200",
                "Total" => $total);
            $response_message = array("SearchIssueByIdResponse" => $message);
            $this->response($response_message);
        } else {
            $message = array("Status" => "1002",
                "Message" => "Invalid token");
            $response_message = array("SearchIssueByIdResponse" => $message);
            $this->response($response_message);
        }
    }
    
    public function centerreport_post() {
        $headers = $this->input->request_headers();
        $valid = $this->Token_modal->exit_token($headers['Token']);
        if ($valid != null) {
            header('Content-type: application/json');
            $object = json_decode(file_get_contents('php://input'), true);

            $fromdate = $object['GetCenterIssueRequest']['Parameters']['fromdate'];
            $todate = $object['GetCenterIssueRequest']['Parameters']['todate'];
            $center = $object['GetCenterIssueRequest']['Center']['name'];
            
            $issue_data = $this->Issue_modal->search_issue_by_center_date($center, $fromdate, $todate);
            $data_issue['Issue'] = $issue_data;
            $message = array("Status" => "200",
                "IssueList" => $data_issue);
            $response_message = array("SearchIssueByIdResponse" => $message);
            $this->response($response_message);
        } else {
            $message = array("Status" => "1002",
                "Message" => "Invalid token");
            $response_message = array("SearchIssueByIdResponse" => $message);
            $this->response($response_message);
        }
    }
    
    public function centerreporttotal_post() {
        $headers = $this->input->request_headers();
        $valid = $this->Token_modal->exit_token($headers['Token']);
        if ($valid != null) {
            header('Content-type: application/json');
            $object = json_decode(file_get_contents('php://input'), true);

            $fromdate = $object['GetCenterIssueTotalRequest']['Parameters']['fromdate'];
            $todate = $object['GetCenterIssueTotalRequest']['Parameters']['todate'];
            $center = $object['GetCenterIssueTotalRequest']['Center']['name'];
            
            $issue_data = $this->Issue_modal->search_issue_by_center_date_total($center, $fromdate, $todate);
            $total = $issue_data[0]->total;
            if($total == null){
                $total  = 0;
            }
            $message = array("Status" => "200",
                "Total" => $total);
            $response_message = array("SearchIssueByIdResponse" => $message);
            $this->response($response_message);
        } else {
            $message = array("Status" => "1002",
                "Message" => "Invalid token");
            $response_message = array("SearchIssueByIdResponse" => $message);
            $this->response($response_message);
        }
    }


}
