<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Farmer
 *
 * @author user
 */
require APPPATH . '/libraries/REST_Controller.php';

class Farmer extends REST_Controller {

    function __construct() {
        parent::__construct();
        $this->load->database();
        $this->load->model('Farmer_modal');
        $this->load->model('Token_modal');
        $this->load->helper('file');
    }

    public function addfarmer_post() {
        $headers = $this->input->request_headers();
        $valid = $this->Token_modal->exit_token($headers['Token']);
        if ($valid != null) {
            header('Content-type: application/json');
            $object = json_decode(file_get_contents('php://input'), true);
            $data = $object['AddFarmerRequest']['Farmer'];

            $farmer = $this->Farmer_modal->exit_farmer($object['AddFarmerRequest']['Farmer']['number']);

            if ($farmer != null) {
                $message = array("Status" => "1003",
                    "Message" => "Farmer Id already exist.");
                $response_message = array("AddFarmerResponse" => $message);
                $this->response($response_message);
            } else {

                $type = $this->Farmer_modal->get_user_type($valid['username']);
                $number = $data['number'];

                if ($type == "Supervisor") {
                    $executive = $this->Farmer_modal->get_executive($valid['username']);
                } else {
                    $executive = $valid['username'];
                }


                $range = $this->Farmer_modal->range_validation($number, $executive);

                if ($range != null) {
                    $this->Farmer_modal->add_farmer($data);
                    $message = array("Status" => "200",
                        "Message" => "Farmer added successfully!");
                    $response_message = array("AddFarmerResponse" => $message);
                    $this->response($response_message);
                } else {
                    $message = array("Status" => "1006",
                        "Message" => "Plot number not in the valid range.");
                    $response_message = array("AddFarmerResponse" => $message);
                    $this->response($response_message);
                }
            }
        } else {
            $message = array("Status" => "1002",
                "Message" => "Invalid token");
            $response_message = array("AddFarmerResponse" => $message);
            $this->response($response_message);
        }
    }

    public function editfarmer_post() {
        $headers = $this->input->request_headers();
        $valid = $this->Token_modal->exit_token($headers['Token']);
        if ($valid != null) {
            header('Content-type: application/json');
            $object = json_decode(file_get_contents('php://input'), true);
            $data = $object['EditFarmerRequest']['Farmer'];
            $farmer = $this->Farmer_modal->exit_farmer($object['EditFarmerRequest']['Farmer']['number']);
            if ($farmer != null) {
                $this->Farmer_modal->edit_farmer($object['EditFarmerRequest']['Farmer']['number'], $data);
                $message = array("Status" => "200",
                    "Message" => " Farmer details successfully updated.");
                $response_message = array("EditFarmerResponse" => $message);
                $this->response($response_message);
            } else {
                $message = array("Status" => "1004",
                    "Message" => "Internal error. Farmer details not updated.");
                $response_message = array("EditFarmerResponse" => $message);
                $this->response($response_message);
            }
        } else {
            $message = array("Status" => "1002",
                "Message" => "Invalid token");
            $response_message = array("EditFarmerResponse" => $message);
            $this->response($response_message);
        }
    }

    public function deletefarmer_post() {
        $headers = $this->input->request_headers();
        $valid = $this->Token_modal->exit_token($headers['Token']);
        if ($valid != null) {
            header('Content-type: application/json');
            $object = json_decode(file_get_contents('php://input'), true);
            $farmer = $this->Farmer_modal->exit_farmer($object['DeleteFarmerRequest']['Farmer']['number']);
            if ($farmer != null) {
                $data = array("number" => $object['DeleteFarmerRequest']['Farmer']['number']);
                $this->Farmer_modal->delete_farmer($data);
                $message = array("Status" => "200",
                    "Message" => " Farmer deleted successfully.");
                $response_message = array("DeleteFarmerResponse" => $message);
                $this->response($response_message);
            } else {
                $message = array("Status" => "1004",
                    "Message" => "Internal error. Farmer not deleted.");
                $response_message = array("DeleteFarmerResponse" => $message);
                $this->response($response_message);
            }
        } else {
            $message = array("Status" => "1002",
                "Message" => "Invalid token");
            $response_message = array("DeleteFarmerResponse" => $message);
            $this->response($response_message);
        }
    }

    public function getfarmerlist_post() {
        $headers = $this->input->request_headers();
        $valid = $this->Token_modal->exit_token($headers['Token']);
        if ($valid != null) {
            $farmer_list = $this->Farmer_modal->get_all_farmer_list();
            $farmer_list_response = array("Farmer" => $farmer_list);
            $message = array("Status" => "200",
                "FarmerList" => $farmer_list_response);

            $response_message = array("GetFarmerListResponse" => $message);
            $this->response($response_message);
        } else {
            $message = array("Status" => "1002",
                "Message" => "Invalid token");
            $response_message = array("DeleteFarmerResponse" => $message);
            $this->response($response_message);
        }
    }

    public function getnextfarmerid_post() {
        $headers = $this->input->request_headers();
        $valid = $this->Token_modal->exit_token($headers['Token']);
        if ($valid != null) {
            $max_farmer_id_list = $this->Farmer_modal->get_max_farmer_id();
            $max_farmer_id = 0;
            foreach ($max_farmer_id_list as $key) {
                $max_farmer_id = $key->number;
            }

            if ($max_farmer_id == 0) {
                $next_farmer_id = intval($max_farmer_id) + 1;
            } else {
                $next_farmer_id = intval($max_farmer_id) + 2;
            }

            $next_farmer_id_response = array("number" => $next_farmer_id);
            $message = array("Status" => "200",
                "Farmer" => $next_farmer_id_response);
            $response_message = array("GetNextFarmerIdResponse" => $message);
            if (true) {
                log_message('error', json_encode($response_message), false);
            }
            $this->response($response_message);
        } else {
            $message = array("Status" => "1002",
                "Message" => "Invalid token");
            $response_message = array("GetNextFarmerIdResponse" => $message);
            if (true) {
                log_message('error', json_encode($response_message), false);
            }
            $this->response($response_message);
        }
    }

    public function serachfarmerwithlimit_post() {
        $headers = $this->input->request_headers();
        $valid = $this->Token_modal->exit_token($headers['Token']);
        if ($valid != null) {
            header('Content-type: application/json');
            $object = json_decode(file_get_contents('php://input'), true);

            $limit = $object['SearchFarmerRequest']['Parameters']['Limit'];



            if (isset($object['SearchFarmerRequest']['Farmer']['number']) && $object['SearchFarmerRequest']['Farmer']['number'] != null) {
                $number = $object['SearchFarmerRequest']['Farmer']['number'];
            }
            if (isset($object['SearchFarmerRequest']['Farmer']['name']) && $object['SearchFarmerRequest']['Farmer']['name'] != null) {
                $name = $object['SearchFarmerRequest']['Farmer']['name'];
            }
            if (isset($object['SearchFarmerRequest']['Farmer']['nic']) && $object['SearchFarmerRequest']['Farmer']['nic'] != null) {
                $nic = $object['SearchFarmerRequest']['Farmer']['nic'];
            }

            if (isset($number) && $number != null) {
                $data['number'] = $number;
            }
            if (isset($name) && $name != null) {
                $data['name'] = $name;
            }
            if (isset($nic) && $nic != null) {
                $data['nic'] = $nic;
            }
            $farmer_list = $this->Farmer_modal->search_farmer_with_limit($limit, $data);
            $count = $this->Farmer_modal->search_farmer_with_limit_count($data);
            if ($count > $limit) {
                $farmer_list_response = array("Farmer" => $farmer_list);
                $message = array("Status" => "200",
                    "MoreResultsExist" => "Y",
                    "FarmerList" => $farmer_list_response);
            } else {
                $farmer_list_response = array("Farmer" => $farmer_list);
                $message = array("Status" => "200",
                    "MoreResultsExist" => "N",
                    "FarmerList" => $farmer_list_response);
            }
            $response_message = array("SearchLimitFarmerListResponse" => $message);
            $this->response($response_message);
        } else {
            $message = array("Status" => "1002",
                "Message" => "Invalid token");
            $response_message = array("SearchLimitFarmerListResponse" => $message);
            $this->response($response_message);
        }
    }

    public function serachfarmerwithoutlimit_post() {
        $headers = $this->input->request_headers();
        $valid = $this->Token_modal->exit_token($headers['Token']);
        if ($valid != null) {
            header('Content-type: application/json');
            $object = json_decode(file_get_contents('php://input'), true);
            if (isset($object['SearchFarmerRequest']['Farmer']['number']) && $object['SearchFarmerRequest']['Farmer']['number'] != null) {
                $number = $object['SearchFarmerRequest']['Farmer']['number'];
            }
            if (isset($object['SearchFarmerRequest']['Farmer']['name']) && $object['SearchFarmerRequest']['Farmer']['name'] != null) {
                $name = $object['SearchFarmerRequest']['Farmer']['name'];
            }
            if (isset($object['SearchFarmerRequest']['Farmer']['nic']) && $object['SearchFarmerRequest']['Farmer']['nic'] != null) {
                $nic = $object['SearchFarmerRequest']['Farmer']['nic'];
            }

            if (isset($number) && $number != null) {
                $data['number'] = $number;
            }
            if (isset($name) && $name != null) {
                $data['name'] = $name;
            }
            if (isset($nic) && $nic != null) {
                $data['nic'] = $nic;
            }
            $farmer_list = $this->Farmer_modal->search_farmer_without_limit($data);
            $farmer_list_response = array("Farmer" => $farmer_list);
            $message = array("Status" => "200",
                "FarmerList" => $farmer_list_response);

            $response_message = array("SearchFarmerListResponse" => $message);
            $this->response($response_message);
        } else {
            $message = array("Status" => "1002",
                "Message" => "Invalid token");
            $response_message = array("GetNextFarmerIdResponse" => $message);
            $this->response($response_message);
        }
    }

    public function getfarmerbyid_post() {
        $headers = $this->input->request_headers();
        $valid = $this->Token_modal->exit_token($headers['Token']);
        if ($valid != null) {
            header('Content-type: application/json');
            $object = json_decode(file_get_contents('php://input'), true);
            $farmerId = $object['GetFarmerByIdRequest']['Farmer']['number'];
            $farmer = $this->Farmer_modal->get_farmer_by_id($farmerId);
            if ($farmer != null) {
                $message = array("Status" => "200",
                    "Farmer" => $farmer);

                $response_message = array("GetFarmerByIdResponse" => $message);
                $this->response($response_message);
            } else {
                $message = array("Status" => "1004",
                    "Message" => "Invalid farmer id.");
                $response_message = array("GetFarmerByIdResponse" => $message);
                $this->response($response_message);
            }
        } else {
            $message = array("Status" => "1002",
                "Message" => "Invalid token");
            $response_message = array("GetFarmerByIdResponse" => $message);
            $this->response($response_message);
        }
    }

}
