<?php

class Executive extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('Mobileuser_modal');
        $this->load->helper(array('form', 'url', 'date'));
        $this->load->library('session');
    }

    public function create() {
        $session_data = $this->session->all_userdata();
        if (isset($session_data['nameheader'])) {
            $data['userheader'] = $session_data['nameheader'];
        } else {
            $data['userheader'] = '';
        }

        if (isset($session_data['username'])) {
            $username = $session_data['username'];
        } else {
            $username = '';
        }
        if ($username != null) {
            $area_select = $this->Mobileuser_modal->get_executive_area();

            $all_area = $this->Mobileuser_modal->get_all_area();
            $area = array();
            $select = array();
            foreach ($all_area as $row) {
                array_push($area, $row->name);
            }
            foreach ($area_select as $value) {
                array_push($select, $value->name);
            }
            $diff_area = array_diff($area, $select);

            $data['area'] = $diff_area;


            $data['suc_msg'] = $this->session->flashdata('create');
            $this->load->view('template/sidebar', $data);
            $this->load->view('template/topnavigation');
            $this->load->view('Executive/Executive_create', $data);
            $this->load->view('template/footer');
        } else {
            $data['error_msg_login'] = "You don't have authorization to access this page!";
            $this->load->view('login', $data);
        }
    }

    public function created() {
        $session_data = $this->session->all_userdata();
        if (isset($session_data['nameheader'])) {
            $data['userheader'] = $session_data['nameheader'];
        } else {
            $data['userheader'] = '';
        }

        if (isset($session_data['username'])) {
            $username = $session_data['username'];
        } else {
            $username = '';
        }
        if ($username != null) {
            $data_executive['username'] = $this->input->post('username');
            $data_executive['firstname'] = $this->input->post('fristname');
            $data_executive['lastname'] = $this->input->post('lastname');
            $data_executive['mobile'] = $this->input->post('mobile');
            $data_executive['type'] = 'Executive';
            $data_executive['password'] = md5($this->input->post('password'));

            $data_area = json_decode($this->input->post('arealist'));
            $data_range = array();
            $username = $this->input->post('username');
            for ($i = 0; $i < 6; $i++) {
                $from = $this->input->post('rangefrom' . strval($i + 1));
                $to = $this->input->post('rangeto' . strval($i + 1));
                if ($from != null && $to != null) {
                    $data_range[$i] = array('type' => 'PN', 'executive' => $username, 'from' => $from, 'to' => $to);
                }
            }
            $this->Mobileuser_modal->insert_executive($data_executive, $data_area, $data_range);
            $this->session->set_flashdata('create', "Executive added successfully.");
            redirect(base_url() . 'index.php/Executive/create');
        } else {
            $data['error_msg_login'] = "You don't have authorization to access this page!";
            $this->load->view('login', $data);
        }
    }

    public function view() {
        $session_data = $this->session->all_userdata();
        if (isset($session_data['nameheader'])) {
            $data['userheader'] = $session_data['nameheader'];
        } else {
            $data['userheader'] = '';
        }

        if (isset($session_data['username'])) {
            $username = $session_data['username'];
        } else {
            $username = '';
        }
        if ($username != null) {
            $update_message = $this->session->flashdata('update');
            $delete_message = $this->session->flashdata('delete');
            if ($update_message != null) {
                $data['suc_msg'] = $this->session->flashdata('update');
            } else if ($delete_message != null) {
                $data['suc_msg'] = $this->session->flashdata('delete');
            }
            $data['user'] = $this->Mobileuser_modal->get_user();
            $this->load->view('template/sidebar', $data);
            $this->load->view('template/topnavigation');
            $this->load->view('Executive/Executive_view');
            $this->load->view('template/footer');
        } else {
            $data['error_msg_login'] = "You don't have authorization to access this page!";
            $this->load->view('login', $data);
        }
    }

    public function viewed() {
        $session_data = $this->session->all_userdata();
        if (isset($session_data['nameheader'])) {
            $data['userheader'] = $session_data['nameheader'];
        } else {
            $data['userheader'] = '';
        }

        if (isset($session_data['username'])) {
            $username = $session_data['username'];
        } else {
            $username = '';
        }
        if ($username != null) {
            $username = $this->input->post('username');

            $data['user'] = $this->Mobileuser_modal->get_user_one($username);
            $area_select = $this->Mobileuser_modal->get_area_select($username);
            $all_area = $this->Mobileuser_modal->get_all_area();
            $area = array();
            $select = array();
            foreach ($all_area as $row) {
                array_push($area, $row->name);
            }
            foreach ($area_select as $value) {
                array_push($select, $value->area);
            }
            $diff_area = array_diff($area, $select);
            $data['area_select'] = $select;
            $data['area_not_select'] = $diff_area;

            $data['range'] = $this->Mobileuser_modal->get_range($username);


            $this->load->view('template/sidebar', $data);
            $this->load->view('template/topnavigation');
            $this->load->view('Executive/Executive_viewed', $data);
            $this->load->view('template/footer');
        } else {
            $data['error_msg_login'] = "You don't have authorization to access this page!";
            $this->load->view('login', $data);
        }
    }

    public function edit() {
        $session_data = $this->session->all_userdata();
        if (isset($session_data['nameheader'])) {
            $data['userheader'] = $session_data['nameheader'];
        } else {
            $data['userheader'] = '';
        }

        if (isset($session_data['username'])) {
            $username = $session_data['username'];
        } else {
            $username = '';
        }
        if ($username != null) {
            $username = $this->input->post('username');
            $data['user'] = $this->Mobileuser_modal->get_user_one($username);
            $area_select = $this->Mobileuser_modal->get_area_select($username);
            $all_area = $this->Mobileuser_modal->get_all_area();
            $area = array();
            $select = array();
            foreach ($all_area as $row) {
                array_push($area, $row->name);
            }
            foreach ($area_select as $value) {
                array_push($select, $value->area);
            }
            $diff_area = array_diff($area, $select);
            $data['area_select'] = $select;

            $data['area_select_json'] = json_encode($select);

            $all_executive_select = $this->Mobileuser_modal->get_executive_area();
            $executive_select = array();
            foreach ($all_executive_select as $value) {
                array_push($executive_select, $value->name);
            }
            $diff_area = array_diff($diff_area, $executive_select);
            $data['area_not_select'] = $diff_area;

            $data['range'] = $this->Mobileuser_modal->get_range($username);


            $this->load->view('template/sidebar', $data);
            $this->load->view('template/topnavigation');
            $this->load->view('Executive/Executive_edit', $data);
            $this->load->view('template/footer');
        } else {
            $data['error_msg_login'] = "You don't have authorization to access this page!";
            $this->load->view('login', $data);
        }
    }

    public function edited() {
        $session_data = $this->session->all_userdata();
        if (isset($session_data['nameheader'])) {
            $data['userheader'] = $session_data['nameheader'];
        } else {
            $data['userheader'] = '';
        }

        if (isset($session_data['username'])) {
            $username = $session_data['username'];
        } else {
            $username = '';
        }
        if ($username != null) {
            $data_executive['username'] = $this->input->post('username');
            $data_executive['firstname'] = $this->input->post('fristname');
            $data_executive['lastname'] = $this->input->post('lastname');
            $data_executive['mobile'] = $this->input->post('mobile');

            $data_area = json_decode($this->input->post('arealist'));

            $data_range = array();
            $username = $this->input->post('username');
            for ($i = 0; $i < 6; $i++) {
                $from = $this->input->post('rangefrom' . strval($i + 1));
                $to = $this->input->post('rangeto' . strval($i + 1));
                if ($from != null && $to != null) {
                    $data_range[$i] = array('type' => 'PN', 'executive' => $username, 'from' => $from, 'to' => $to);
                }
            }

            $this->Mobileuser_modal->update_executive($data_executive, $data_area, $data_range, $username);
            $this->session->set_flashdata('update', "Executive updated successfully.");
            redirect(base_url() . 'index.php/Executive/view');
        } else {
            $data['error_msg_login'] = "You don't have authorization to access this page!";
            $this->load->view('login', $data);
        }
    }

    public function delete() {
        $session_data = $this->session->all_userdata();
        if (isset($session_data['username'])) {
            $name = $session_data['username'];
        } else {
            $name = '';
        }
        if ($name != null) {

            $username = $this->input->post('username');
            $this->Mobileuser_modal->delete_executive($username);
            $data['STATUS'] = 'TRUE';
            $this->session->set_flashdata('delete', "Executive deleted successfully.");
        }
        echo json_encode($data);
    }

    public function username_exsist() {

        $username = $this->input->post('username');
        $data_username = $this->Mobileuser_modal->get_username_exsist($username);
        if ($data_username != null) {
            echo json_encode(false);
        } else {
            echo json_encode(true);
        }
    }

    public function area_exist() {

        $area = json_decode($this->input->post('area'));
        $data_exist = $this->Mobileuser_modal->get_validate_area($area);
        if ($data_exist != null) {
            $data['STATUS'] = 'FALSE';
        } else {
            $data['STATUS'] = 'TRUE';
        }
        echo json_encode($data);
    }

}
