<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Crop
 *
 * @author user
 */
require APPPATH . '/libraries/REST_Controller.php';

class Crop extends REST_Controller {

    function __construct() {
        parent::__construct();
        $this->load->database();
        $this->load->model('Crop_modal');
        $this->load->model('Token_modal');
        $this->load->model('User_modal');
        $this->load->model('Issue_modal');
    }

    public function addcrop_post() {
        $headers = $this->input->request_headers();
        $valid = $this->Token_modal->exit_token($headers['Token']);
        if ($valid != null) {
            header('Content-type: application/json');
            $object = json_decode(file_get_contents('php://input'), true);
            $data = $object['AddCropRequest']['Crop'];
            $data_response = $object['AddCropRequest']['Crop'];
            $data['username'] = $valid['username'];

            $crop = $this->Crop_modal->exit_crop($object['AddCropRequest']['Crop']['slipno']);

            if ($crop != null) {
                $message = array("Status" => "1003",
                    "Message" => "Crop Id already exist.");
                $response_message = array("AddCropResponse" => $message);
                $this->response($response_message);
            } else {
                $this->Crop_modal->add_crop($data);
                $message = array("Status" => "200",
                    "Message" => "Crop added successfully!",
                    "Crop" => $data_response);
                $response_message = array("AddCropResponse" => $message);
                $this->response($response_message);
            }
        } else {
            $message = array("Status" => "1002",
                "Message" => "Invalid token");
            $response_message = array("AddCropResponse" => $message);
            $this->response($response_message);
        }
    }

    public function editcrop_post() {
        $headers = $this->input->request_headers();
        $valid = $this->Token_modal->exit_token($headers['Token']);
        if ($valid != null) {
            header('Content-type: application/json');
            $object = json_decode(file_get_contents('php://input'), true);
            $data = $object['EditCropRequest']['Crop'];
            $data_response = $object['EditCropRequest']['Crop'];
            $crop = $this->Crop_modal->exit_crop($object['EditCropRequest']['Crop']['slipno']);
            if ($crop != null) {
                $this->Crop_modal->edit_crop($object['EditCropRequest']['Crop']['slipno'], $data);
                $message = array("Status" => "200",
                    "Message" => "Crop details successfully updated.",
                    "Crop" => $data_response);
                $response_message = array("EditCropResponse" => $message);
                $this->response($response_message);
            } else {
                $message = array("Status" => "1004",
                    "Message" => "Internal error. Crop details not updated.");
                $response_message = array("EditCropResponse" => $message);
                $this->response($response_message);
            }
        } else {
            $message = array("Status" => "1002",
                "Message" => "Invalid token");
            $response_message = array("EditCropResponse" => $message);
            $this->response($response_message);
        }
    }

    public function deletecrop_post() {
        $headers = $this->input->request_headers();
        $valid = $this->Token_modal->exit_token($headers['Token']);
        if ($valid != null) {
            header('Content-type: application/json');
            $object = json_decode(file_get_contents('php://input'), true);
            $crop = $this->Crop_modal->exit_crop($object['DeleteCropRequest']['Crop']['slipno']);
            if ($crop != null) {
                $data = array("slipno" => $object['DeleteCropRequest']['Crop']['slipno']);
                $this->Crop_modal->delete_crop($data);
                $message = array("Status" => "200",
                    "Message" => " Crop deleted successfully.");
                $response_message = array("DeleteCropResponse" => $message);
                $this->response($response_message);
            } else {
                $message = array("Status" => "1004",
                    "Message" => "Internal error. Cropp not deleted.");
                $response_message = array("DeleteCropResponse" => $message);
                $this->response($response_message);
            }
        } else {
            $message = array("Status" => "1002",
                "Message" => "Invalid token");
            $response_message = array("DeleteCropResponse" => $message);
            $this->response($response_message);
        }
    }

    public function getnextcropslipno_post() {
        $headers = $this->input->request_headers();
        $valid = $this->Token_modal->exit_token($headers['Token']);
        if ($valid != null) {
            $max_slip_no_list = $this->Crop_modal->get_max_slip_no();

            foreach ($max_slip_no_list as $key) {
                $max_slip_no = $key->slipno;
            }
            $next_slip_no = intval($max_slip_no) + 1;
            $message = array("Status" => "200",
                "slipno" => $next_slip_no);

            $response_message = array("GetNextCropSlipNooResponse" => $message);
            $this->response($response_message);
        } else {
            $message = array("Status" => "1002",
                "Message" => "Invalid token");
            $response_message = array("GetNextCropSlipNooResponse" => $message);
            $this->response($response_message);
        }
    }

    public function serachcroplimit_post() {
        $headers = $this->input->request_headers();
        $valid = $this->Token_modal->exit_token($headers['Token']);
        if ($valid != null) {
            header('Content-type: application/json');
            $object = json_decode(file_get_contents('php://input'), true);
            $limit = $object['SearchCropByIdRequest']['Parameters']['Limit'];
            $slipno = $object['SearchCropByIdRequest']['Crop']['slipno'];
            $crop_list = $this->Crop_modal->search_crop_with_limit($limit, $slipno);
            $user_type = $this->Issue_modal->get_user_type($valid['username']);
            foreach ($crop_list as $value) {
                $farmerno = $value->farmerno;
                $date = $value->date;
                $payement = $this->Crop_modal->get_payemnt_result_crop($farmerno, $date);
                if ($payement != null) {
                    $value->processed = 1;
                } else {
                    $value->processed = 0;
                }
                if ($user_type == 'Supervisor') {
                    $value->updatable = 0;
                } else {
                    $supervisor_exit = $this->Issue_modal->get_my_supervisor($valid['username'], $value->username);
                    if (($valid['username'] == $value->username) && $payement == null) {
                        $value->updatable = 1;
                    } else if ($supervisor_exit != null && $payement == null) {
                        $value->updatable = 1;
                    } else {
                        $value->updatable = 0;
                    }
                }
            }
            $count = $this->Crop_modal->search_crop_with_limit_count($slipno);

            if ($count > $limit) {
                $crop_list_response = array("Crop" => $crop_list);
                $message = array("Status" => "200",
                    "MoreResultsExist" => "Y",
                    "CropList" => $crop_list_response);
            } else {
                $crop_list_response = array("Crop" => $crop_list);
                $message = array("Status" => "200",
                    "MoreResultsExist" => "N",
                    "CropList" => $crop_list_response);
            }

            $response_message = array("SearchCropByIdResponse" => $message);
            $this->response($response_message);
        } else {
            $message = array("Status" => "1002",
                "Message" => "Invalid token");
            $response_message = array("SearchCropByIdResponse" => $message);
            $this->response($response_message);
        }
    }

    public function serachcrop_post() {
        $headers = $this->input->request_headers();
        $valid = $this->Token_modal->exit_token($headers['Token']);
        if ($valid != null) {
            header('Content-type: application/json');
            $object = json_decode(file_get_contents('php://input'), true);
            $slipno = $object['SearchCropByIdRequest']['Crop']['slipno'];
            $crop_list = $this->Crop_modal->search_crop($slipno);
            $user_type = $this->Issue_modal->get_user_type($valid['username']);
            foreach ($crop_list as $value) {
                $farmerno = $value->farmerno;
                $date = $value->date;
                $payement = $this->Crop_modal->get_payemnt_result_crop($farmerno, $date);
                if ($payement != null) {
                    $value->processed = 1;
                } else {
                    $value->processed = 0;
                }
                if ($user_type == 'Supervisor') {
                    $value->updatable = 0;
                } else {
                    $supervisor_exit = $this->Issue_modal->get_my_supervisor($valid['username'], $value->username);
                    if (($valid['username'] == $value->username) && $payement == null) {
                        $value->updatable = 1;
                    } else if ($supervisor_exit != null && $payement == null) {
                        $value->updatable = 1;
                    } else {
                        $value->updatable = 0;
                    }
                }
            }
            $crop_list_response = array("Crop" => $crop_list);
            echo $crop_list_response;
            $message = array("Status" => "200",
                "CropList" => $crop_list_response);

            $response_message = array("SearchCropByIdResponse" => $message);
            $this->response($response_message);
        } else {
            $message = array("Status" => "1002",
                "Message" => "Invalid token");
            $response_message = array("SearchCropByIdResponse" => $message);
            $this->response($response_message);
        }
    }

    public function getmycroplistwithlimit_post() {
        $headers = $this->input->request_headers();
        $valid = $this->Token_modal->exit_token($headers['Token']);
        if ($valid != null) {
            header('Content-type: application/json');
            $object = json_decode(file_get_contents('php://input'), true);
            $limit = $object['GetMyCropListRequest']['Parameters']['Limit'];

            $username = $this->User_modal->get_username($headers['Token']);
            $crop_list = $this->Crop_modal->get_my_crop_list_with_limit($limit, $username);
            $user_type = $this->Issue_modal->get_user_type($valid['username']);
            foreach ($crop_list as $value) {
                $farmerno = $value->farmerno;
                $date = $value->date;
                $payement = $this->Crop_modal->get_payemnt_result_crop($farmerno, $date);
                if ($payement != null) {
                    $value->processed = 1;
                } else {
                    $value->processed = 0;
                }
                if ($user_type == 'Supervisor') {
                    $value->updatable = 0;
                } else {
                    $supervisor_exit = $this->Issue_modal->get_my_supervisor($valid['username'], $value->username);
                    if (($valid['username'] == $value->username) && $payement == null) {
                        $value->updatable = 1;
                    } else if ($supervisor_exit != null && $payement == null) {
                        $value->updatable = 1;
                    } else {
                        $value->updatable = 0;
                    }
                }
            }
            $count = $this->Crop_modal->get_my_crop_list_with_limit_count($username);
            ;

            if ($count > $limit) {
                $crop_list_response = array("Crop" => $crop_list);
                $message = array("Status" => "200",
                    "MoreResultsExist" => "Y",
                    "CropList" => $crop_list_response);
            } else {
                $crop_list_response = array("Crop" => $crop_list);
                $message = array("Status" => "200",
                    "MoreResultsExist" => "N",
                    "CropList" => $crop_list_response);
            }

            $response_message = array("GetMyCropListResponse" => $message);
            $this->response($response_message);
        } else {
            $message = array("Status" => "1002",
                "Message" => "Invalid token");
            $response_message = array("GetMyCropListResponse" => $message);
            $this->response($response_message);
        }
    }

    public function getmycroplistwithoutlimit_get() {
        $headers = $this->input->request_headers();
        $valid = $this->Token_modal->exit_token($headers['Token']);
        if ($valid != null) {
            $username = $this->User_modal->get_username($headers['Token']);
            $crop_list = $this->Crop_modal->get_my_crop_list_without_limit($username);
            $user_type = $this->Issue_modal->get_user_type($valid['username']);
            foreach ($crop_list as $value) {
                $farmerno = $value->farmerno;
                $date = $value->date;
                $payement = $this->Crop_modal->get_payemnt_result_crop($farmerno, $date);
                if ($payement != null) {
                    $value->processed = 1;
                } else {
                    $value->processed = 0;
                }
                if ($user_type == 'Supervisor') {
                    $value->updatable = 0;
                } else {
                    $supervisor_exit = $this->Issue_modal->get_my_supervisor($valid['username'], $value->username);
                    if (($valid['username'] == $value->username) && $payement == null) {
                        $value->updatable = 1;
                    } else if ($supervisor_exit != null && $payement == null) {
                        $value->updatable = 1;
                    } else {
                        $value->updatable = 0;
                    }
                }
            }
            $crop_list_response = array("Crop" => $crop_list);
            $message = array("Status" => "200",
                "CropList" => $crop_list_response);

            $response_message = array("GetMyCropListResponse" => $message);
            $this->response($response_message);
        } else {
            $message = array("Status" => "1002",
                "Message" => "Invalid token");
            $response_message = array("GetMyCropListResponse" => $message);
            $this->response($response_message);
        }
    }

    public function farmerreport_post() {
       $headers = $this->input->request_headers();
       $valid = $this->Token_modal->exit_token($headers['Token']);
       if ($valid != null) {
           header('Content-type: application/json');
           $object = json_decode(file_get_contents('php://input'), true);

           $fromdate = $object['GetFarmerCropRequest']['Parameters']['fromdate'];
           $todate = $object['GetFarmerCropRequest']['Parameters']['todate'];
           $farmerno = $object['GetFarmerCropRequest']['Farmer']['number'];

           $crop_data['Crop'] = $this->Crop_modal->search_crop_by_farmer_date($farmerno, $fromdate, $todate);
           $message = array("Status" => "200",
               "CropList" => $crop_data);
           $response_message = array("GetFarmerCropResponse" => $message);
           $this->response($response_message);
       } else {
           $message = array("Status" => "1002",
               "Message" => "Invalid token");
           $response_message = array("GetFarmerCropResponse" => $message);
           $this->response($response_message);
       }
   }   
   
    public function farmerreporttotal_post() {
       $headers = $this->input->request_headers();
       $valid = $this->Token_modal->exit_token($headers['Token']);
       if ($valid != null) {
            header('Content-type: application/json');
            $object = json_decode(file_get_contents('php://input'), true);

            $fromdate = $object['GetFarmerCropTotalRequest']['Parameters']['fromdate'];
            $todate = $object['GetFarmerCropTotalRequest']['Parameters']['todate'];
            $farmerno = $object['GetFarmerCropTotalRequest']['Farmer']['number'];

            $crop_data = $this->Crop_modal->search_crop_total_by_farmer_date($farmerno, $fromdate, $todate);
            $message = array("Status" => "200",
                "Total" => $crop_data);
            $response_message = array("GetFarmerCropTotalResponse" => $message);
            $this->response($response_message);
       } else {
           $message = array("Status" => "1002",
               "Message" => "Invalid token");
           $response_message = array("GetFarmerCropTotalResponse" => $message);
           $this->response($response_message);
       }
   }  
   
   public function centerreport_post() {
       $headers = $this->input->request_headers();
       $valid = $this->Token_modal->exit_token($headers['Token']);
       if ($valid != null) {
           header('Content-type: application/json');
           $object = json_decode(file_get_contents('php://input'), true);

           $fromdate = $object['GetCenterCropRequest']['Parameters']['fromdate'];
           $todate = $object['GetCenterCropRequest']['Parameters']['todate'];
           $center = $object['GetCenterCropRequest']['Center']['name'];

           $crop_data['Crop'] = $this->Crop_modal->search_crop_by_center_date($center, $fromdate, $todate);
           $message = array("Status" => "200",
               "CropList" => $crop_data);
           $response_message = array("GetFarmerCropResponse" => $message);
           $this->response($response_message);
       } else {
           $message = array("Status" => "1002",
               "Message" => "Invalid token");
           $response_message = array("GetFarmerCropResponse" => $message);
           $this->response($response_message);
       }
   }   
   
    public function centerreporttotal_post() {
       $headers = $this->input->request_headers();
       $valid = $this->Token_modal->exit_token($headers['Token']);
       if ($valid != null) {
            header('Content-type: application/json');
            $object = json_decode(file_get_contents('php://input'), true);

            $fromdate = $object['GetCenterCropTotalRequest']['Parameters']['fromdate'];
            $todate = $object['GetCenterCropTotalRequest']['Parameters']['todate'];
            $center = $object['GetCenterCropTotalRequest']['Center']['name'];

            $crop_data = $this->Crop_modal->search_crop_total_by_center_date($center, $fromdate, $todate);
            $message = array("Status" => "200",
                "Total" => $crop_data);
            $response_message = array("GetFarmerCropTotalResponse" => $message);
            $this->response($response_message);
       } else {
           $message = array("Status" => "1002",
               "Message" => "Invalid token");
           $response_message = array("GetFarmerCropTotalResponse" => $message);
           $this->response($response_message);
       }
   }  
   
}
