<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Area
 *
 * @author user
 */
require APPPATH . '/libraries/REST_Controller.php';

class Area extends REST_Controller {

    function __construct() {
        parent::__construct();
        $this->load->database();
        $this->load->model('Area_modal');
        $this->load->model('Token_modal');
    }

    
    public function getarea_get() {
        $headers = $this->input->request_headers();
        $valid = $this->Token_modal->exit_token($headers['Token']);
        if ($valid != null) {
            header('Content-type: application/json');
            $area=  $this->Area_modal->get_area_list();
            $area_list=array("Area" => $area);
            $message = array("Status" => "200",
                "AreaList" => $area_list);
            $response_message = array("GetAreaResponse" => $message);
            $this->response($response_message);
        } else {
            $message = array("Status" => "1002",
                "Message" => "Invalid token");
            $response_message = array("GetAreaResponse" => $message);
            $this->response($response_message);
        }
    }
    public function addarea_post() {
        $id = $this->post('id');
        $name = $this->post('name');
        $executive = $this->post('executive');
        $acerage = $this->post('acerage');
        $qty = $this->post('qty');
        
        $area = $this->Area_modal->exit_area($id);

        if ($area != null) {
            $message = array("Status" => "1003",
                "Message" => "Area already exist.");
            $response_message = array("AddAreaResponse" => $message);
            $this->response($response_message);
        } else {
            $data = array("id" => $id,
                "name" => $name,
                "executive" => $executive,
                "acerage" => $acerage,
                "qty" => $qty);
            $this->Area_modal->add_area($data);
            $message = array("Status" => "200",
                "Message" => "Area added successfully!");
            $response_message = array("AddAreaResponse" => $message);
            $this->response($response_message);
        }
    }

    public function editarea_post() {
        $id = $this->post('id');
        $name = $this->post('name');
        $executive = $this->post('executive');
        $acerage = $this->post('acerage');
        $qty = $this->post('qty');

        $area = $this->Area_modal->exit_area($id);

        if ($area != null) {
            $data = array("name" => $name,
                "executive" => $executive,
                "acerage" => $acerage,
                "qty" => $qty);
            $this->Area_modal->edit_area($id, $data);
            $message = array("Status" => "200",
                "Message" => "Area details successfully updated.");
            $response_message = array("EditAreaResponse" => $message);
            $this->response($response_message);
        } else {
            $message = array("Status" => "1004",
                "Message" => "Internal error. Area details not updated.");
            $response_message = array("EditAreaResponse" => $message);
            $this->response($response_message);
        }
    }

    public function deletearea_post() {
        $id = $this->post('id');
        $area = $this->Area_modal->exit_area($id);

        if ($area != null) {
            $data = array("id" => $id);
            $this->Area_modal->delete_area($data);
            $message = array("Status" => "200",
                "Message" => "Area deleted successfully.");
            $response_message = array("DeleteAreaResponse" => $message);
            $this->response($response_message);
        } else {
            $message = array("Status" => "1004",
                "Message" => "Internal error. Area not deleted.");
            $response_message = array("DeleteAreaResponse" => $message);
            $this->response($response_message);
        }
    }

}
